;========================================================================================
; Description:      Bug Hunter
; Author(s):        mrbond007 (Baki G)
;					Northwind (Frank Abbing)
;					JPAM (JPAM van der Ouderaa)
;
;					Remember if you like AutoIt Donate to the AutoIt Project:
;					http://www.autoitscript.com/donate.php
;========================================================================================
If _Singleton("Bug Hunter") = 0 Then Exit

#include "Plugins\ProSpeed.au3"
#include "Plugins\BassMod.au3"
#include "Plugins\Misc.au3"
#include "Plugins\Array.au3"
Opt("GUIOnEventMode", 1)
Opt("MouseCoordMode", 2)
HotKeySet("{Esc}", "Close")

Global $MainGui, $GTitle = "Bug Hunter"
Global $Dll = DllOpen("user32.dll")
Global $ResourcePath = @ScriptDir & "\Bug Hunter\"
Global $MPath = $ResourcePath & "Music\"
Global $PPath = $ResourcePath & "Pictures\"
Global $BugPos[2][2] = [["20","540"],["20","350"]], $PosX, $PosY
Global $Bugs[1], $Pressed = 0, $Bullets[28], $XPos = -15, $Trigger = 0
Global $Count = 0, $SpeedCount = 3, $Level[2], $number = 0, $GameRunning = 1, $Gun
Global $Sprite1 = $PPath & "nishan.png", _
		$Sprite2 = $PPath & "poison1.png", _
		$Sprite3 = $PPath & "poison2.png", _
		$Sprite4 = $PPath & "poison3.png", _
		$Sprite5 = $PPath & "poison4.png", _
		$Sprite6 = $PPath & "poison5.png", _
		$Sprite7 = $PPath & "bullet.png", _
		$Sprite8 = $PPath & "blood.png", _
		$Sprite9 = $PPath & "level.png", _
		$Sprite10 = $PPath & "numbers.png", _
		$Sprite11 = $PPath & "game.png", _
		$Sprite12 = $PPath & "over.png", _
		$Sound1 = $MPath & "001-System01.wav", _
		$Sound2 = $MPath & "001-System02.wav"

$MainGui = GUICreate($GTitle, 600, 430)
GUISetOnEvent(-3, "Close")
GUISetState()
GUISetCursor(16)

DSoundInit()
$Bullet = DSoundLoad($Sound1)
$Killed = DSoundLoad($Sound2)
$Background = Background($PPath & "\fake.png", 0, 0, 600, 430)
$Nishan = LoadSprite($Sprite1)
$BugSpr1 = LoadSprite($Sprite2)
$BugSpr2 = LoadSprite($Sprite3)
$BugSpr3 = LoadSprite($Sprite4)
$BugSpr4 = LoadSprite($Sprite5)
$BugSpr5 = LoadSprite($Sprite6)
$BulletSpr = LoadSprite($Sprite7)
$BloodSpr = LoadSprite($Sprite8)
$LevelSpr = LoadSprite($Sprite9)
$NumberSpr = loadsprite($Sprite10)
$GameSpr = loadsprite($Sprite11)
$OverSpr = loadsprite($Sprite12)
$Gun = sprite($Nishan, 0, 0, 30, 30, 1, 1, 0, 0, 0)
SetSpriteSpeed($Gun, 100, 100)

_Create_Level()
_PrepareTrack($MPath & "Track.mod")
_BassVolume(50)
WinSetState($MainGui, "", @SW_SHOW)

While 1
	Sleep(50)
	$Pos = MouseGetPos()
	MoveSprite($Gun, $Pos[0], $Pos[1]) ;move the mark sprite same as you move the mouse
	Select
		Case $GameRunning = 0
			FreezeGame()
		Case _IsPressed("01", $Dll)
			If WinActive($MainGui) Then
				$Pressed += 1
				If $Pressed = 1 Then _Shoot_Bullet() ;shoots a bulllet when you press the left mouse button
			EndIf
		Case Else
			$Pressed = 0
	EndSelect
WEnd

Func _Create_Level() ;creates a level
	HotKeySet("z")
	Local $RandomBugs = Random(5, 9, 1), $Resize = -1, $Dim

	$Count += 1 ;counts the levels
	$SpeedCount += 1 ;the speed of bugs increases each level
	$NewBug = Eval("BugSpr" & $Count)

	If $SpeedCount >= 9 Then $SpeedCount = 9
	If $Count > 7 Then GameOver() ;when you reach level 7 the game ends

	For $i = 0 To UBound($Bullets)-1
		$XPos += 22
		$Bullets[$i] = sprite($BulletSpr, 0, 0, 11, 20, 1, 1, 0, $XPos, 410) ;draws the bullets
	Next
	_ShowLevel_Info() ;displays level information

	If $Count <= 5 Then
		For $i = 0 To $RandomBugs
			$Dim += 1
			$Resize += 1
			ReDim $Bugs[$Dim]
			_Create_Bug($Count, $Bugs[$Resize], $NewBug, $SpeedCount, $SpeedCount)
		Next
	ElseIf $Count > 5 Then
		For $i = 0 To $RandomBugs
			$BugR = Random(1, 5, 1)
			$NewBug = Eval("BugSpr" & $BugR)
			$Dim += 1
			$Resize += 1
			ReDim $Bugs[$Dim]
			_Create_Bug($BugR, $Bugs[$Resize], $NewBug, $SpeedCount, $SpeedCount)
		Next
	EndIf
	AdlibEnable("_MoveBugs", 100)
	HotKeySet("z", "Pause")
EndFunc

Func _Create_Bug($szParam, ByRef $szArray, $szDraw, $szSpeedX, $szSpeedY) ;creates the bugs
	Select
		Case $szParam = 1
			$szArray = sprite($szDraw, 0, 0, 48, 49, 6, 1, 0, Random(10, 100, 1), 100)
			SetSpriteAnim($szArray, 0, 0, 48, 49, 6, 1, 13)
		Case $szParam = 2
			$szArray = sprite($szDraw, 0, 0, 50, 39, 9, 1, 0, Random(10, 100, 1), 100)
			SetSpriteAnim($szArray, 0, 0, 50, 39, 9, 1, 13)
		Case $szParam = 3
			$szArray = sprite($szDraw, 0, 0, 50, 100, 5, 1, 0, Random(10, 100, 1), 100)
			SetSpriteAnim($szArray, 0, 0, 50, 100, 5, 1, 13)
		Case $szParam = 4
			$szArray = sprite($szDraw, 0, 0, 46, 46, 10, 1, 0, Random(10, 100, 1), 100)
			SetSpriteAnim($szArray, 0, 0, 46, 46, 10, 1, 13)
		Case $szParam = 5
			$szArray = sprite($szDraw, 0, 0, 45, 45, 9, 1, 0, Random(10, 100, 1), 100)
			SetSpriteAnim($szArray, 0, 0, 45, 45, 9, 1, 13)
	EndSelect
	SetSpriteSpeed($szArray, $szSpeedX, $szSpeedY)
EndFunc

Func _ShowLevel_Info() ;shows level information
	Local $TargetX, $TargetY

	$number += 1
	$Level[0] = sprite($LevelSpr, 0, 0, 60, 21, 1, 1, 0, -110, 200)
	$Level[1] = sprite($NumberSpr, 0, 0, 18, 21, 15, $number, 0, 570, 200)
	SetSpriteSpeed($Level[0], 5, 5)
	SetSpriteSpeed($Level[1], 4, 4)
	MoveSprite($Level[0], 220, 200)
	MoveSprite($Level[1], 320, 200)
	Sleep(3500)
	DeleteSprite($Level[0])
	DeleteSprite($Level[1])
EndFunc

Func _MoveBugs() ;moves bugs around the screen (AI)
	$WinGetPos = WinGetPos($MainGui)
	SetMouseRect($WinGetPos[0] + 20, $WinGetPos[1] + 40, ($WinGetPos[0] + $WinGetPos[2]) - 50, ($WinGetPos[1] + $WinGetPos[3]) - 45)

	For $i = 0 To UBound($Bugs)-1
		If HasSpriteArrived($Bugs[$i]) <> 0 Then
			$Pos1 = Random($BugPos[0][0], $BugPos[0][1], 1)
			$Pos2 = Random($BugPos[1][0], $BugPos[1][1], 1)
			MoveSprite($Bugs[$i], $Pos1, $Pos2)
		EndIf
	Next
EndFunc

Func _Shoot_Bullet()
	If UBound($Bullets)-1 >= 1 Then ;when there are enough bullets
		$LostBullet = (UBound($Bullets)-1) - 1
		DSoundPlay($Bullet, 0, 0)
		DeleteSprite($Bullets[$LostBullet]) ;removes the bullets from the screen
		_ArrayDelete($Bullets, $LostBullet)
		For $i = 0 To UBound($Bugs)-1
			If Collide($Gun, $Bugs[$i]) <> 0 Then ;did the bullet hit a bug?
				$PusX = GetSpriteX($Bugs[$i])
				$PusY = GetSpriteY($Bugs[$i])
				DSoundPlay($Killed, 0, 0)
				DeleteSprite($Bugs[$i])
				_ArrayDelete($Bugs, $i)
				$Blood = sprite($BloodSpr, 0, 0, 38, 37, 8, 1, 0, $PusX, $PusY) ;sets blood on the screen
				SetSpriteAnim($Blood, 0, 0, 38, 37, 8, 1, 1)
				Sleep(150)
				DeleteSprite($Blood)
				ExitLoop
			EndIf
		Next
	Else ;no more bullets
		GameOver() ;game over
	EndIf
	If UBound($Bugs) < 1 Then _Level_Finished() ;all bugs killed
EndFunc

Func _Level_Finished()
	AdlibDisable()

	For $i = 0 To UBound($Bullets)-1
		DeleteSprite($Bullets[$i])
	Next

	$Bugs = ""
	$Bullets = ""

	Dim $Bullets[28], $Xpos = -15, $Bugs[1]
	_Create_Level() ;all bugs died
EndFunc

Func GameOver()
	AdlibDisable()
	$Level[0] = sprite($GameSpr, 0, 0, 60, 21, 1, 1, 0, -210, 200)
	$Level[1] = sprite($OverSpr, 0, 0, 56, 21, 1, 1, 0, 600, 200)
	SetSpriteSpeed($Level[0], 6, 4)
	SetSpriteSpeed($Level[1], 4, 4)
	MoveSprite($Level[0], 220, 200)
	MoveSprite($Level[1], 310, 200)
	Sleep(4000)
	DeleteSprite($Level[0])
	DeleteSprite($Level[1])
	Close()
EndFunc

Func Pause() ;prepares the game to be paused
	If WinActive($MainGui) Then
		$Trigger += 1
		If $Trigger = 1 Then
			$GameRunning = 0
			For $i = 0 To UBound($Bugs)-1
				$PosX = GetSpriteX($Bugs[$i])
				$PosY = GetSpriteY($Bugs[$i])
				MoveSprite($Bugs[$i], $PosX, $PosY)
			Next
			_PauseMusic()
			AdlibDisable()
			WinSetTitle($MainGui, "", "Paused")
			GUISetCursor(2)
			SetMouseRect(0, 0, @DesktopWidth, @DesktopHeight)
		ElseIf $Trigger = 2 Then
			$GameRunning = 1
			_PlayMusic()
			$Trigger = 0
			AdlibEnable("_MoveBugs", 100)
			WinSetTitle($MainGui, "", $GTitle)
			GUISetCursor(16)
		EndIf
	EndIf
EndFunc

Func FreezeGame() ;pause the game
	Do
		Sleep(50)
	Until $GameRunning = 1
EndFunc

Func Close() ;closes the game and releases the allocated resources
	DeleteAllSprites()
	FreeExtBmp($Background)
	_StopMusic()
	_FreeBass()
	GUIDelete($MainGui)
	DllClose($Dll)
	Exit
EndFunc